# 3.x Upgrade Guide

## Breaking changes

### Node support

Dropped support for Node 8, 9, 10. Minimum supported version of Node.js is now 12.

### Dereferenced schemas for `anyOf`/`allOf` options

`MultiSchemaField`'s `options` interface is different. Before, an option could include a `$ref`. Now, any option with a reference will be resolved/dereferenced when given as props for `MultiSchemaField`.

### Help field IDs

IDs for [Help fields](../api-reference/uiSchema.md#help) are now suffixed by `__help` so that the IDs are unique. Previously, their IDs would be nonexistent or the same as the fields that they were describing.

### Bring your own polyfills

core-js@2 has been removed from @rjsf/core. See more about [the rationale here](https://github.com/rjsf-team/react-jsonschema-form/pull/2211#issue-563700810).

If you're using a framework like [Create React App](https://create-react-app.dev/docs/supported-browsers-features#supported-browsers), [Gatsby](https://www.gatsbyjs.com/docs/how-to/custom-configuration/browser-support/), [Next.js](https://nextjs.org/docs/basic-features/supported-browsers-features), or transpiling code through something like `@babel/preset-env`, polyfills are already included there and you won't have to do anything.

If you were directly depending on @rjsf/core's @babel/runtime pulling in core-js@2, just `npm install core-js` and using a side effectful import at the top of your entry point (`import 'core-js'`) might be enough.

For a slightly more elaborate setup, [@babel/preset-env](https://babeljs.io/docs/en/babel-preset-env#how-does-it-work) is probably a good second choice.

From `@babel/preset-env`'s docs

> We leverage [`browserslist`, `compat-table`, and `electron-to-chromium`] to maintain mappings of which version of our supported target environments gained support of a JavaScript syntax or browser feature, as well as a mapping of those syntaxes and features to Babel transform plugins and core-js polyfills.
